using System;

using gov.va.med.vbecs.DAL.HL7.OpenLibrary;

namespace gov.va.med.vbecs.DAL.HL7AL
{
	/// <summary>
	/// This exception is thrown when network problems are preventing 
	/// normal HL7 functioning.
	/// </summary>
	public class HL7NetworkErrorException : HL7Exception
	{
		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8299"> 
		///		<ExpectedInput>No input required</ExpectedInput>
		///		<ExpectedOutput>Non-null HL7NetworkErrorException.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8300"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Default constructor. Error message is self-contained and cannot be changed.
		/// </summary>
		public HL7NetworkErrorException()
			: base() {}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8301"> 
		///		<ExpectedInput>Message input parameter set to "Unit Test Exception".</ExpectedInput>
		///		<ExpectedOutput>Non-null HL7NetworkErrorException with Message property set to "Unit Test Exception"</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8302"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public HL7NetworkErrorException( string message ) 
			: base( message ) {}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8303"> 
		///		<ExpectedInput>Message input parameter set to "Unit Test Exception" and innerException
		///		type of ArgumentNullException.</ExpectedInput>
		///		<ExpectedOutput>Non-null HL7NetworkErrorException with Message property set to "Unit Test Exception"
		///		and inner exception type of ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8304"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="innerException">Inner exception that caused this exception.</param>
		public HL7NetworkErrorException( string message, Exception innerException )
			: base( message, innerException ) {}
	}
}
